function [image,Energies,CorrNew,Cut1New,Cut2New,Fine,FineAlignLog] = FineAlignZLPLoad(image,Energies,FWHM,EnergyRes)

FineAlignLog = {[];[]};
I            = 1;
EStart       = [];
EWidth       = [];
Corr         = zeros([size(image,1),size(image,2)]);
CorrIP       = zeros([size(image,1),size(image,2)]);
Cut1New      = 0;
Cut2New      = 0;
CorrNew      = Corr;
Fine         = 0;

while 1
    
    if I==1
        Answer = questdlg('FineAlign ZLP?','Yes','No');
    else
        Answer = questdlg('FineAlign ZLP again?','Yes','No');
    end
    switch Answer
        case 'Yes'
           
        otherwise
            clearvars -except image Energies CorrNew Cut1New Cut2New FineAlignLog Fine
            return
    end
    
    Spec              = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
    Spec              = max(Spec,[],1);
    fig               = figure('Name','Select region with ZLP for BroadAlign - double click to confirm!');
    
    plot(Energies,Spec,'Color','b');
    hold on
    plot(Energies,zeros(size(Energies)),'--','Color','k');
    hold off
    legend('mean normed Spectrum');
    ylabel( 'normed Counts [a.u.]' );
    xlabel( 'Loss energy [eV]' );
    ylim([-max(Spec)/2,max(Spec).*1.25]);
    xlim([min(Energies,[],2),max(Energies,[],2)]);
    
    maxEne            = max(Spec,[],2);
    minEne            = min(Spec,[],2);
    ZLP               = (minEne + maxEne) / 10;
    index1            = (find(Spec >= ZLP, 1, 'first'));
    index2            = (find(Spec >= ZLP, 1, 'last'));
    Start             = Energies(index1)- mean(FWHM,'all')*2;
    Width             = Energies(index2)- Start + mean(FWHM,'all')*2;
    if Start+Width > Energies(end)
        Width = Energies(End)-Start;
    end
    
    try
        Select  = drawrectangle('Position',[Start,-max(Spec)/2,Width,max(Spec)/2+max(Spec).*1.25],'Color','b','StripeColor','w');
        l       = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
        uiwait;
        pos     = Select.Position;
        Ind1    = pos(1);
        Ind2    = pos(1)+pos(3);
        Ind1    = find(Energies>=Ind1,1,'first');
        Ind2    = find(Energies<=Ind2,1,'last');
        delete(Select);
        close(fig);
        delete(l);
    catch
        clearvars -except image Energies CorrNew Cut1New Cut2New FineAlignLog Fine
        return
    end
    
 
    
    %% Calculate Peak position
    [~,ZeroPos] = min(abs(Energies));                                          % Gives position of the zero.
    
    %% Cross Correlation function
    SizeX      = size(image,2);
    SizeY      = size(image,1);
    SizeZ      = size(image,3);
    
    Kernel      = reshape(image(:,:,Ind1:Ind2),[SizeY*SizeX,size(image(:,:,Ind1:Ind2),3)]);
    Kernel      = Kernel./sum(Kernel,2);
    Kernel      = mean(Kernel,1);
    [~,Lag]     = CrossAlign(Kernel,Kernel);
    [~,MaxPos]  = max(Kernel);
    CorrShift   = ZeroPos-(MaxPos+Ind1-1);
    Lag         = Lag - CorrShift;
    
    img         = reshape(image,[SizeY*SizeX,SizeZ]);
    img         = img(:,Ind1:Ind2)./sum(img,2);
    [CF,~]      = CrossAlign(img,Kernel);
    
    CF          = reshape(CF,[SizeY,SizeX,size(CF,2)]);
    
    WaitTics  = size(image,1);
    WaitAlign = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
    Sigma     = mean(FWHM,'all')/(2*sqrt(2*log(2)));
    options  = optimset('Display','none','TolFun',1e-5,'TolX',1e-5);
    for i=1:size(image,1)
        for j=1:size(image,2)
            a      = 0;
            cf     = reshape(CF(i,j,:)   ,[1,size(CF   ,3)]);
            img    = reshape(image(i,j,:),[1,size(image,3)]);
            
            %% Correct Energies
            cf          = cf./max(cf);
            eqn         = @(x) sum((cf- x(1).*exp(-(Lag-x(2)).^2/(2.*x(3).^2))).^2);
            x           = [1,0,Sigma];
            x           = fminsearch(eqn,x,options);
            Shift       = x(2);
        
            if Shift > 10 || ~isreal(Shift)
                warndlg(['Fit too unstable for ZLP(',num2str(i),',',num2str(j),')!']);
                clearvars -except image Energies CorrNew Cut1New Cut2New FineAlignLog Fine
                return
            end
            RShift       = round(Shift);
            SShift       = (Shift-RShift).*EnergyRes;
            
            img          = circshift(img,-RShift,3);
            image(i,j,:) = interp1(Energies-SShift,img,Energies,'linear');
            Corr(i,j)    = Shift.*EnergyRes;
            CorrIP(i,j)  = SShift;
        end
        %% Check Waitbar exist
        Flag = CheckWaitbar1(WaitAlign);
        if Flag==1
            clearvars -except image Energies CorrNew Cut1New Cut2New FineAlignLog Fine
            clear global
            return
        end
        WaitAlign.Send;
        
    end
    WaitAlign.Destroy;
    
    I = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
    I = sum(I,1);

    [~,MaxPos] = max(I);
    Shift      = ZeroPos - MaxPos;
    image      = circshift(image,Shift,3);
    Corr       = Corr - Shift.*EnergyRes;

    %% Cut ends
    % Due to the alignment, there are points at the boundarys of the spectra, that do not belong
    % to their current energy position, as it was shifted circularry over the
    % edge. E.g: a point belonging to -3eV is now circulary shifted to
    % +20eV. To cut those points out, the maximum shift has to be found. Image
    % and Dispersion then are corrected correspondingly.
    
    Cut1     = floor(min(Corr,[],'all')./EnergyRes);
    Cut2     =  ceil(max(Corr,[],'all')./EnergyRes);
    
    CutIP1   = floor(min(CorrIP,[],'all')./EnergyRes);
    CutIP2   =  ceil(max(CorrIP,[],'all')./EnergyRes);
    
    Cut1     = min(Cut1,CutIP1);
    Cut2     = max(Cut2,CutIP2);
    
    EOld2    = Energies;

    if Cut2>0
        image    = image(:,:,1:end-Cut2);
        Energies = Energies(:,1:end-Cut2);
        Cut2New  = Cut2New + Cut2;
    end
    if Cut1<0
        image    = image(:,:,1-Cut1:end);
        Energies = Energies(:,1-Cut1:end);
        Cut1New   = Cut1New + -Cut1;
    end

    MaxDrift2     = max(abs(Corr),[],'all');
    [row,col]     = find(abs(Corr)==MaxDrift2);
    MaxDrift2     = Corr(row,col);
    CorrNew       = CorrNew + Corr;
    
    Fine = 1;
    FineAlignLog{1,1}= ['FineAlign:  FitType: Gauss Fit to Cross Correl.  |  StartVal: ' , num2str(EOld2(Ind1)),'eV  |  EndVal: ', num2str(EOld2(Ind2)),'eV  |  max Drift: ',num2str(MaxDrift2),'eV'];

    I=I+1;
    
end
end